/*
 * periodentafelTest.cpp
 *
 *  Created on: May 18, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <sstream>
#include <iostream>

#include "Helpers/Assert.hpp"

#include "World.hpp"
#include "periodentafelTest.hpp"
#include "element.hpp"
#include "elements_db.hpp"
#include "periodentafel.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( periodentafelTest );


void periodentafelTest::setUp()
{
  // make sure world is present
  tafel = World::getInstance().getPeriode();
  CPPUNIT_ASSERT(tafel != NULL && "could not obtain periodentafel");
};


void periodentafelTest::tearDown()
{
  World::purgeInstance();
};

/** UnitTest for AddRemoveTest().
 */
void periodentafelTest::AddRemoveTest()
{
  // copy the element
  const element * ElementPtr = tafel->FindElement(3);
  CPPUNIT_ASSERT( ElementPtr != NULL && "could not find element lithium");
  element *Elemental = new element(*ElementPtr);
  // remove element
  tafel->RemoveElement((element * const)ElementPtr);
  ElementPtr = tafel->FindElement(3);
  CPPUNIT_ASSERT_EQUAL( (const element *)NULL, ElementPtr );
  // add element again
  tafel->AddElement((element * const)Elemental);
  ElementPtr = tafel->FindElement(3);
  CPPUNIT_ASSERT( ElementPtr != NULL && "could not find re-added element lithium");
};

/** UnitTest for LoadStoreTest().
 * TODO: periodentafelTest::LoadStoreTest() not implemented yet
 */
void periodentafelTest::LoadStoreTest()
{
  // reload all databases
  stringstream elementsDBstream(elementsDB,ios_base::in);
  CPPUNIT_ASSERT(tafel->LoadElementsDatabase(elementsDBstream) && "General element initialization failed");
  CPPUNIT_ASSERT(tafel->LoadValenceDatabase(new stringstream(valenceDB,ios_base::in)) && "Valence entry of element initialization failed");
  CPPUNIT_ASSERT(tafel->LoadOrbitalsDatabase(new stringstream(orbitalsDB,ios_base::in)) && "Orbitals entry of element initialization failed");
  CPPUNIT_ASSERT(tafel->LoadHBondAngleDatabase(new stringstream(HbondangleDB,ios_base::in)) && "HBond angle entry of element initialization failed");
  CPPUNIT_ASSERT(tafel->LoadHBondLengthsDatabase(new stringstream(HbonddistanceDB,ios_base::in)) && "HBond distance entry of element initialization failed");
  // check presence of elements
  atomicNumber_t Z = 1;
  for(periodentafel::const_iterator ElementRunner = tafel->begin(); ElementRunner != tafel->end(); ++ElementRunner)
    CPPUNIT_ASSERT( (ElementRunner->second->getNumber() == Z++) && "element is missing in sequence");
};
