/*
 * VerboseAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/VerboseAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

// memento to remember the state when undoing

class CommandLineVerboseState : public ActionState {
public:
  CommandLineVerboseState(const int _oldverbosity, const int _newverbosity) :
    oldverbosity(_oldverbosity),
    newverbosity(_newverbosity)
  {}
  int oldverbosity;
  int newverbosity;
};


const char CommandLineVerboseAction::NAME[] = "verbose";

CommandLineVerboseAction::CommandLineVerboseAction() :
  Action(NAME)
{}

CommandLineVerboseAction::~CommandLineVerboseAction()
{}

void CommandVerbose(int verbosity) {
  ValueStorage::getInstance().setCurrentValue(CommandLineVerboseAction::NAME, verbosity);
  ActionRegistry::getInstance().getActionByName(CommandLineVerboseAction::NAME)->call(Action::NonInteractive);
};

Dialog* CommandLineVerboseAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryInt(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr CommandLineVerboseAction::performCall() {
  int oldverbosity = getVerbosity();
  int newverbosity = 2;

  ValueStorage::getInstance().queryCurrentValue(NAME, newverbosity);

  if (oldverbosity != newverbosity) {
    CommandLineVerboseState *UndoState = new CommandLineVerboseState(oldverbosity, newverbosity);
    setVerbosity(newverbosity);
    DoLog(0) && (Log() << Verbose(0) << "Setting verbosity from " << oldverbosity << " to " << newverbosity << "." << endl);
    return Action::state_ptr(UndoState);
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Verbosity remains unchanged at " << oldverbosity << "." << endl);
    return Action::failure;
  }
}

Action::state_ptr CommandLineVerboseAction::performUndo(Action::state_ptr _state) {
  CommandLineVerboseState *state = assert_cast<CommandLineVerboseState*>(_state.get());

  DoLog(0) && (Log() << Verbose(0) << "Setting verbosity from " << state->newverbosity << " to " << state->oldverbosity << "." << endl);
  setVerbosity(state->oldverbosity);

  return Action::state_ptr(_state);
}

Action::state_ptr CommandLineVerboseAction::performRedo(Action::state_ptr _state){
  CommandLineVerboseState *state = assert_cast<CommandLineVerboseState*>(_state.get());

  DoLog(0) && (Log() << Verbose(0) << "Setting verbosity from " << state->oldverbosity << " to " << state->newverbosity << "." << endl);
  setVerbosity(state->newverbosity);

  return Action::state_ptr(_state);
}

bool CommandLineVerboseAction::canUndo() {
  return true;
}

bool CommandLineVerboseAction::shouldUndo() {
  return true;
}

const string CommandLineVerboseAction::getName() {
  return NAME;
}
