/*
 * FastParsingAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/FastParsingAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

// memento to remember the state when undoing

class CommandLineFastParsingState : public ActionState {
public:
  CommandLineFastParsingState(const bool _oldvalue, const bool _newvalue) :
    oldvalue(_oldvalue),
    newvalue(_newvalue)
  {}
  bool oldvalue;
  bool newvalue;
};


const char CommandLineFastParsingAction::NAME[] = "fastparsing";

CommandLineFastParsingAction::CommandLineFastParsingAction() :
  Action(NAME)
{}

CommandLineFastParsingAction::~CommandLineFastParsingAction()
{}

void CommandFastParsing(bool fastparsing) {
  ValueStorage::getInstance().setCurrentValue(CommandLineFastParsingAction::NAME, fastparsing);
  ActionRegistry::getInstance().getActionByName(CommandLineFastParsingAction::NAME)->call(Action::NonInteractive);
};

Dialog* CommandLineFastParsingAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryBoolean(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr CommandLineFastParsingAction::performCall() {
  config *configuration = World::getInstance().getConfig();
  bool oldvalue = configuration->FastParsing;
  bool newvalue;
  ValueStorage::getInstance().queryCurrentValue(NAME, newvalue);
  configuration->FastParsing = newvalue;
  if (configuration->FastParsing)
    DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
  else
    DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);
  return Action::state_ptr(new CommandLineFastParsingState(oldvalue, newvalue));
}

Action::state_ptr CommandLineFastParsingAction::performUndo(Action::state_ptr _state) {
  CommandLineFastParsingState *state = assert_cast<CommandLineFastParsingState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->FastParsing = state->oldvalue;
  if (configuration->FastParsing)
    DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
  else
    DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);

  return Action::state_ptr(_state);
}

Action::state_ptr CommandLineFastParsingAction::performRedo(Action::state_ptr _state){
  CommandLineFastParsingState *state = assert_cast<CommandLineFastParsingState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->FastParsing = state->newvalue;
  if (configuration->FastParsing)
    DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
  else
    DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);

  return Action::state_ptr(_state);
}

bool CommandLineFastParsingAction::canUndo() {
  return true;
}

bool CommandLineFastParsingAction::shouldUndo() {
  return true;
}

const string CommandLineFastParsingAction::getName() {
  return NAME;
}
