/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MenuDescriptionUnitTest.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "MenuDescriptionUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MenuDescriptionTest );


void MenuDescriptionTest::setUp()
{
};


void MenuDescriptionTest::tearDown()
{
};

/** UnitTest for consistency.
 * we check that we have the same keys in each of MenuSet, MenuDescription and MenuNameMap.
 */
void MenuDescriptionTest::ConsistencyCheck()
{
  // from MenuSet
  for(MenuDescription::const_iterator iter = md.MenuPositionMap->begin(); iter != md.MenuPositionMap->end(); ++iter) {
    const std::string &MenuName = iter->first;
    CPPUNIT_ASSERT_MESSAGE( "menu "+MenuName+" not contained in MenuDescription::MenuDescriptionsMap", md.MenuDescriptionsMap->find(MenuName) != md.MenuDescriptionsMap->end());
    CPPUNIT_ASSERT_MESSAGE( "menu "+MenuName+" not contained in MenuDescription::MenuNameMap", md.MenuNameMap->find(MenuName) != md.MenuNameMap->end());
  }

  // from MenuDescriptionsMap
  for(std::map<std::string const, std::string const>::const_iterator iter = md.MenuDescriptionsMap->begin(); iter != md.MenuDescriptionsMap->end(); ++iter) {
    CPPUNIT_ASSERT_MESSAGE( "menu "+iter->first+" not contained in MenuDescription::MenuSet", md.MenuPositionMap->find(iter->first) != md.MenuPositionMap->end());
    CPPUNIT_ASSERT_MESSAGE( "menu "+iter->first+" not contained in MenuDescription::MenuNameMap", md.MenuNameMap->find(iter->first) != md.MenuNameMap->end());
  }

  // from MenuNameMap
  for(std::map<std::string const, std::string const>::const_iterator iter = md.MenuNameMap->begin(); iter != md.MenuNameMap->end(); ++iter) {
    CPPUNIT_ASSERT_MESSAGE( "menu "+iter->first+" not contained in MenuDescription::MenuDescriptionsMap", md.MenuDescriptionsMap->find(iter->first) != md.MenuDescriptionsMap->end());
    CPPUNIT_ASSERT_MESSAGE( "menu "+iter->first+" not contained in MenuDescription::MenuSet", md.MenuPositionMap->find(iter->first) != md.MenuPositionMap->end());
  }

};
