/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */
/*
 * CreatorUnitTest.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */
// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CreatorUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Assert.hpp"

#include <typeinfo>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( CreatorTest );


void CreatorTest::setUp()
{
  testingA1 = NULL;
  testingA2 = NULL;
  testingB1 = NULL;
  testingB2 = NULL;
}

void CreatorTest::tearDown()
{
  delete testingA1;
  delete testingA2;
  delete testingB1;
  delete testingB2;
}

void CreatorTest::CreationTest()
{
  testingA1 = teststubA.create();
  testingA2 = teststubA.create();
  testingB1 = teststubB.create();

  // instance is different
  CPPUNIT_ASSERT( &teststubA != testingA1 );
  CPPUNIT_ASSERT( &teststubA != testingA2 );
  CPPUNIT_ASSERT( testingA1 != testingA2 );
  CPPUNIT_ASSERT( &teststubB != testingB1 );

  // type is the same ...
  CPPUNIT_ASSERT_EQUAL( typeid(teststubA).name(), typeid(*testingA1).name() );
  CPPUNIT_ASSERT_EQUAL( typeid(*testingA1).name(), typeid(*testingA2).name() );
  CPPUNIT_ASSERT_EQUAL( typeid(teststubB).name(), typeid(*testingB1).name() );

  // ... for the same particular type only!
  // (RTTI knows about the true complex type!)
  CPPUNIT_ASSERT( typeid(*testingB1).name() != typeid(*testingA1).name() );
  CPPUNIT_ASSERT( typeid(*testingB1).name() != typeid(*testingA2).name() );

  // but not for different encapsulated types
  CPPUNIT_ASSERT( typeid(teststubA).name() != typeid(*testingB1).name() );
  CPPUNIT_ASSERT( typeid(teststubB).name() != typeid(*testingA1).name() );
  CPPUNIT_ASSERT( typeid(teststubB).name() != typeid(*testingA2).name() );

}

void CreatorTest::IndividualityTest()
{
  teststubA.count();
  teststubB.count();
  teststubB.count();

  testingA1 = teststubA.create();
  testingA2 = teststubA.create();
  testingB1 = teststubB.create();
  testingB2 = teststubB.create();

  // content is the same (prototype has been copied)
  CPPUNIT_ASSERT( teststubA.getcount() != testingA1->getcount());
  CPPUNIT_ASSERT( teststubA.getcount() != testingA2->getcount());
  CPPUNIT_ASSERT( teststubB.getcount() != testingB1->getcount());
  CPPUNIT_ASSERT( teststubB.getcount() != testingB2->getcount());

  // but each copy is independent
  testingA1->count();
  CPPUNIT_ASSERT( testingA1->getcount() != testingA2->getcount());
  testingB1->count();
  testingB2->count();
  testingB2->count();
  CPPUNIT_ASSERT( testingB1->getcount() != testingB2->getcount());
}
