/*
 * TextDialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef TEXTDIALOG_HPP_
#define TEXTDIALOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>

#include "Dialog.hpp"

class atom;
class element;
class molecule;
class Vector;

class TextDialog : public Dialog
{
public:
  TextDialog();
  virtual ~TextDialog();

  virtual void queryEmpty(const char *, std::string = "");
  virtual void queryBoolean(const char *, std::string = "");
  virtual void queryInt(const char *, std::string = "");
  virtual void queryInts(const char *, std::string = "");
  virtual void queryUnsignedInt(const char *, std::string = "");
  virtual void queryUnsignedInts(const char *, std::string = "");
  virtual void queryString(const char*, std::string = "");
  virtual void queryStrings(const char*, std::string = "");
  virtual void queryDouble(const char*, std::string = "");
  virtual void queryDoubles(const char*, std::string = "");
  virtual void queryAtom(const char*,std::string = "");
  virtual void queryAtoms(const char*,std::string = "");
  virtual void queryMolecule(const char*,std::string = "");
  virtual void queryMolecules(const char*,std::string = "");
  virtual void queryVector(const char*,bool, std::string = "");
  virtual void queryVectors(const char*,bool, std::string = "");
  virtual void queryBox(const char*, std::string = "");
  virtual void queryElement(const char*, std::string = "");
  virtual void queryElements(const char*, std::string = "");
  virtual void queryFile(const char*, std::string = "");
  virtual void queryRandomNumberDistribution_Parameters(const char*, std::string = "");

protected:
  // specialized stuff for text queries
  // all placed into Query/TextQuery.hpp
  // !please adhere to alphabetical ordering!
  class AtomTextQuery;
  class AtomsTextQuery;
  class BooleanTextQuery;
  class BoxTextQuery;
  class DoubleTextQuery;
  class DoublesTextQuery;
  class ElementTextQuery;
  class ElementsTextQuery;
  class EmptyTextQuery;
  class FileTextQuery;
  class IntTextQuery;
  class IntsTextQuery;
  class MoleculeTextQuery;
  class MoleculesTextQuery;
  class StringTextQuery;
  class StringsTextQuery;
  class UnsignedIntTextQuery;
  class UnsignedIntsTextQuery;
  class VectorTextQuery;
  class VectorsTextQuery;
  class RandomNumberDistribution_ParametersTextQuery;
};

#endif /* TEXTDIALOG_HPP_ */
