/*
 * TypeEnumContainer.hpp
 *
 *  Created on: Oct 27, 2010
 *      Author: heber
 */

#ifndef TYPEENUMCONTAINER_HPP_
#define TYPEENUMCONTAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <map>
#include <typeinfo>

class TypeEnumContainer {
public:
  TypeEnumContainer();
  ~TypeEnumContainer();

  /** Enumeration of all possible input types.
   *
   */
  enum EnumOfTypes { NoneType,
        BooleanType,
        BoxType,
        FileType,
        ListOfFilesType,
        IntegerType,
        ListOfIntegersType,
        UnsignedIntegerType,
        ListOfUnsignedIntegersType,
        DoubleType,
        ListOfDoublesType,
        StringType,
        ListOfStringsType,
        VectorType,
        ListOfVectorsType,
        AtomType,
        ListOfAtomsType,
        MoleculeType,
        ListOfMoleculesType,
        ElementType,
        ListOfElementsType,
        RandomNumberDistribution_ParametersType
  };

  typedef std::map< const std::type_info *, enum EnumOfTypes >  type_map;

  enum EnumOfTypes getEnumforType(const std::type_info *_type);

  void ListAllKnownTypes() const;

private:
  // type to enum map for AddOptionToParser()
  type_map TypeEnumMap;
};


#endif /* TYPEENUMCONTAINER_HPP_ */
