/*
 * Reaction_impl.hpp
 *
 *  Created on: Oct 13, 2011
 *      Author: heber
 */

#ifndef REACTION_IMPL_HPP_
#define REACTION_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Assert.hpp"

#include "Actions/Action.hpp"

#include <cassert>

using namespace MoleCuilder;

template<typename T>
Reaction<T>::Reaction(const ActionTrait &_trait) :
  Action(_trait),
  result(0),
  done(false)
{}

template<typename T>
Reaction<T>::~Reaction()
{
  delete result;
}

template<typename T>
ActionState::ptr Reaction<T>::performCall(){
  reset();
  (*this)();
  return Action::success;
}

template<typename T>
ActionState::ptr Reaction<T>::performUndo(ActionState::ptr){
  ASSERT(0,"Cannot undo a calculation");
  return Action::success;
}
template<typename T>
ActionState::ptr Reaction<T>::performRedo(ActionState::ptr){
  ASSERT(0,"Cannot redo a calculation");
  return Action::success;
}

template<typename T>
bool Reaction<T>::canUndo()
{
  return false;
}

template<typename T>
bool Reaction<T>::shouldUndo()
{
  return false;
}

// methods for calculation infrastructure

template<typename T>
T Reaction<T>::operator()(){
  if(!done){
    result = doCalc();
    done = true;
  }
  return *result;
}

template<typename T>
bool Reaction<T>::hasResult(){
  return done;
}

template<typename T>
T Reaction<T>::getResult(){
  ASSERT(done, "Reaction<T>::getResult() - No result calculated yet.");
  return *result;
}

template<typename T>
void Reaction<T>::reset(){
  done = false;
  delete result;
  result = NULL;
}

#endif /* REACTION_IMPL_HPP_ */
