/*
 * Reaction.hpp
 *
 *  Created on: Oct 13, 2011
 *      Author: heber
 */

#ifndef REACTION_HPP_
#define REACTION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Actions/Action.hpp"

namespace MoleCuilder {

/**
 * A Reaction is an Action with a return value that is set during the call and may be
 * inspected afterwards.
 *
 * This class can be used in the same way as any other Action, but has some special methods
 * for inspecting the result of the calculation.
 */
template<typename T>
class Reaction : public Action
{
public:
  Reaction(const ActionTrait &_trait);
  virtual ~Reaction();

  /**
   * Reimplemented call method for Action Base class.
   * Resets the result and then redoes the calculation. Can be used to retrigger calculations
   * from menu Items or other places.
   */
  virtual bool canUndo();

  virtual bool shouldUndo();

  /**
   * Does the actual calculation and returns the result.
   * When the calculation has been done before it is not redone, but the previous cached result is returned.
   * Call reset to delete the cached value.
   */
  virtual T operator()();

  /**
   * Check if a cached result is available.
   */
  virtual bool hasResult();

  /**
   * Get the cached result.
   * Fails if there is no cached result.
   */
  virtual T getResult();

  /**
   * Delete a previously calculated result from the cache.
   */
  virtual void reset();

protected:
  virtual Dialog *fillDialog(Dialog *dialog)=0;

protected:
  //!> result of the calculation
  T* result;

  /**
   * Pure virtual method for implementation of the actual calculation procedure.
   */
  virtual T* doCalc()=0;
private:
  virtual ActionState::ptr performCall();
  virtual ActionState::ptr performUndo(ActionState::ptr);
  virtual ActionState::ptr performRedo(ActionState::ptr);

  //!> states whether result is done or not (i.e. \a result contains valid result
  bool done;
};

}

#endif /* REACTION_HPP_ */
