/*
 * OptionRegistry.hpp
 *
 *  Created on: Oct 26, 2010
 *      Author: heber
 */

#ifndef OPTIONREGISTRY_HPP_
#define OPTIONREGISTRY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CodePatterns/Registry.hpp"
#include "CodePatterns/Singleton.hpp"

namespace MoleCuilder {

class OptionTrait;

/** Option Registry.
 *
 * The Option registry is a storage for any Option of Actions instance to retrieved by name.
 * It is a singleton and can be called from anywhere.
 *
 */
class OptionRegistry : public Singleton<OptionRegistry>, public ::Registry<OptionTrait>
{
  friend class Singleton<OptionRegistry>;

public:
  const OptionTrait * getOptionByName(const std::string name) const;
  bool isOptionPresentByName(const std::string name) const;

  void ConsistencyCheck();

private:
  OptionRegistry();
  ~OptionRegistry();

  // initializer called in constructor
  //void Init();
};

}

#endif /* OPTIONREGISTRY_HPP_ */
