/*
 * MethodAction.hpp
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

#ifndef METHODACTION_HPP_
#define METHODACTION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>
#include <string>

#include "Actions/Action.hpp"

namespace MoleCuilder {

class ActionRegistry;

/**
 * Wrapper class that allows the construction of Actions from any kind of Method
 */
class MethodAction : public Action
{
public:
  MethodAction(const ActionTrait &_trait,boost::function<void()> _executeMethod);
  virtual ~MethodAction();
  virtual bool canUndo();
  virtual bool shouldUndo();

protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual ActionState::ptr performCall();
  virtual ActionState::ptr performUndo(ActionState::ptr);
  virtual ActionState::ptr performRedo(ActionState::ptr);


  boost::function<void()> executeMethod; //!< this stores the method to be called
};

}

#endif /* METHODACTION_HPP_ */
