/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MethodAction.cpp
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <boost/function.hpp>
#include <string>

#include "Actions/MethodAction.hpp"
#include "CodePatterns/Assert.hpp"

using namespace MoleCuilder;

MethodAction::MethodAction(const ActionTrait &_trait,boost::function<void()> _executeMethod) :
   Action(_trait),
executeMethod(_executeMethod)
{
}

MethodAction::~MethodAction()
{}

Dialog* MethodAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}


ActionState::ptr MethodAction::performCall() {
  executeMethod();
  // we don't have a state to save so we return Action::success
  return Action::success;
}

ActionState::ptr MethodAction::performUndo(ActionState::ptr) {
  ASSERT(0,"Cannot undo a MethodAction");
  return Action::success;
}

ActionState::ptr MethodAction::performRedo(ActionState::ptr){
  ASSERT(0,"Cannot redo a MethodAction");
  return Action::success;
}

bool MethodAction::canUndo() {
  return false;
}

bool MethodAction::shouldUndo(){
  return true;
}
