/*
 * ManipulateAtomsProcess.hpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#ifndef MANIPULATEATOMSPROCESS_HPP_
#define MANIPULATEATOMSPROCESS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Actions/Process.hpp"

#include<boost/function.hpp>

#include "Descriptors/AtomDescriptor.hpp"

class World;

namespace MoleCuilder {

class ActionRegistry;

class ManipulateAtomsProcess : public Process
{
public:
  ManipulateAtomsProcess(boost::function<void(atom*)> _operation, AtomDescriptor descr,const ActionTrait &_trait);
  virtual ~ManipulateAtomsProcess();

  virtual bool canUndo();
  virtual bool shouldUndo();

  virtual void doManipulate(World *);

protected:
  virtual Dialog * fillDialog(Dialog*);
private:
  virtual ActionState::ptr performCall();
  virtual ActionState::ptr performUndo(ActionState::ptr);
  virtual ActionState::ptr performRedo(ActionState::ptr);

  AtomDescriptor descr;
  boost::function<void(atom*)> operation;
};

}

#endif /* MANIPULATEATOMSPROCESS_HPP_ */
