/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ManipulateAtomsProcess.cpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ManipulateAtomsProcess.hpp"

#include <iostream>

#include "World.hpp"
#include "CodePatterns/Assert.hpp"

using namespace MoleCuilder;

ManipulateAtomsProcess::ManipulateAtomsProcess(
    boost::function<void(atom*)> _operation,
    AtomDescriptor _descr,
    const ActionTrait &_trait) :
  Process(0,_trait),
  descr(_descr),
  operation(_operation)
{}

ManipulateAtomsProcess::~ManipulateAtomsProcess()
{}

Dialog* ManipulateAtomsProcess::fillDialog(Dialog *dialog){
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}

ActionState::ptr ManipulateAtomsProcess::performCall(){
  World::getInstance().doManipulate(this);
  return Action::success;
}

ActionState::ptr ManipulateAtomsProcess::performUndo(ActionState::ptr){
  ASSERT(0,"Undo called for a ManipulateAtomsProcess");
  return Action::success;
}

ActionState::ptr ManipulateAtomsProcess::performRedo(ActionState::ptr){
  ASSERT(0,"Redo called for a ManipulateAtomsProcess");
  return Action::success;
}

bool ManipulateAtomsProcess::canUndo(){
  return false;
}

bool ManipulateAtomsProcess::shouldUndo(){
  return true;
}

void ManipulateAtomsProcess::doManipulate(World *world){
  setMaxSteps(world->numAtoms());
  start();
  for(World::internal_AtomIterator
      iter=world->getAtomIter_internal(descr);
      iter!=world->atomEnd_internal();
      ++iter){

    setCurrStep(iter.getCount());
    operation(*iter);
  }
  stop();
}
