/*
 * MakroAction.hpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

#ifndef MAKROACTION_HPP_
#define MAKROACTION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>

#include "Actions/Action.hpp"

namespace MoleCuilder {
  class ActionRegistry;
  class ActionSequence;

/**
 * Action to allow producing bigger Actions from sequences of small actions.
 *
 * Destruction of the Actions and the sequence is handled by this class.
 */
class MakroAction : public Action
{
public:
  MakroAction(const ActionTrait &_trait,ActionSequence& _actions);
  virtual ~MakroAction();

  bool canUndo();
  bool shouldUndo();

  // must be called after all primitive actions are present
  virtual void prepare(ActionRegistry &AR);
  // must be called before alle primitive actions are removed
  virtual void unprepare(ActionRegistry &AR);

protected:
  virtual Dialog *fillDialog(Dialog *dialog);

  virtual ActionState::ptr performCall();
  virtual ActionState::ptr performUndo(ActionState::ptr);
  virtual ActionState::ptr performRedo(ActionState::ptr);

  void setLoop(unsigned int _loop);

private:
  ActionSequence &actions;
};

}

#endif /* MAKROACTION_HPP_ */
