/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ErrorAction.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "Actions/ErrorAction.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "CodePatterns/Assert.hpp"

using namespace MoleCuilder;

ErrorAction::ErrorAction(const ActionTrait &_trait,const char * _errorMsg) :
Action(_trait),
errorMsg(_errorMsg)
{
}

ErrorAction::~ErrorAction()
{
}

Dialog* ErrorAction::createDialog() {
  return NULL;
}

ActionState::ptr ErrorAction::performCall() {
  ELOG(0, errorMsg);
  return Action::success;
}
ActionState::ptr ErrorAction::performUndo(ActionState::ptr) {
  ASSERT(0,"Undo called for an ErrorAction");
  return Action::success;
}

ActionState::ptr ErrorAction::performRedo(ActionState::ptr) {
  ASSERT(0,"Redo called for an ErrorAction");
  return Action::success;
}

bool ErrorAction::canUndo(){
  return false;
}

bool ErrorAction::shouldUndo(){
  return false;
}
