/*
 * Calculation.hpp
 *
 *  Created on: Feb 19, 2010
 *      Author: crueger
 */

#ifndef CALCULATION_HPP_
#define CALCULATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Actions/Process.hpp"

namespace MoleCuilder {

class ActionRegistry;

/**
 * A calculation is a Process that has some kind of result.
 *
 * This class can be used in the same way as any other Action or Process, but has some special methods
 * for inspecting the result of the calculation.
 */
template<typename T>
class Calculation : public Process
{
public:
  Calculation(int _maxSteps, const ActionTrait &_trait);
  virtual ~Calculation();

  /**
   * Reimplemented call method for Action Base class.
   * Resets the result and then redoes the calculation. Can be used to retrigger calculations
   * from menu Items or other places.
   */
  virtual bool canUndo();

  virtual bool shouldUndo();

  /**
   * Does the actual calculation and returns the result.
   * When the calculation has been done before it is not redone, but the previous cached result is returned.
   * Call reset to delete the cached value.
   */
  virtual T operator()();

  /**
   * Check if a cached result is available.
   */
  virtual bool hasResult();

  /**
   * Get the cached result.
   * Fails if there is no cached result.
   */
  virtual T getResult();

  /**
   * Delete a previously calculated result from the cache.
   */
  virtual void reset();

protected:
  T* result;

  /**
   * Pure virtual method for implementation of the actual calculation procedure.
   */
  virtual T* doCalc()=0;
private:
  virtual ActionState::ptr performCall();
  virtual ActionState::ptr performUndo(ActionState::ptr);
  virtual ActionState::ptr performRedo(ActionState::ptr);

  bool done;
};

}

#endif /* CALCULATION_HPP_ */
