/*
 * AtomsCalculation_impl.hpp
 *
 *  Created on: Feb 19, 2010
 *      Author: crueger
 */

#ifndef ATOMSCALCULATION_IMPL_HPP_
#define ATOMSCALCULATION_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Actions/AtomsCalculation.hpp"
#include "Actions/Calculation_impl.hpp"

using namespace MoleCuilder;

template<typename T>
AtomsCalculation<T>::AtomsCalculation(boost::function<T(atom*)> _op,const ActionTrait &_trait,AtomDescriptor _descr) :
  Calculation<std::vector<T> >(0,_trait),
  descr(_descr),
  op(_op)
{}

template<typename T>
AtomsCalculation<T>::~AtomsCalculation(){
}

template<typename T>
std::vector<T>* AtomsCalculation<T>::doCalc(){
  World* world = World::getPointer();
  int steps = world->numAtoms();
  std::vector<T> *res = new std::vector<T>();
  res->reserve(steps);
  Process::setMaxSteps(steps);
  Process::start();
  for(World::internal_AtomIterator
      iter=world->getAtomIter_internal(descr);
      iter!=world->atomEnd_internal();
      ++iter){

    Process::setCurrStep(iter.getCount());
    res->push_back(op(*iter));
  }
  Process::stop();
  return res;
}

template<typename T>
Dialog *AtomsCalculation<T>::fillDialog(Dialog *dialog){
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}

#endif /* ATOMSCALCULATION_IMPL_HPP_ */
