/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ActionQueue.cpp
 *
 *  Created on: Aug 16, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/ActionQueue.hpp"

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/IteratorAdaptors.hpp"
#include "CodePatterns/Singleton_impl.hpp"

#include <vector>

#include "Actions/ActionHistory.hpp"
#include "Actions/ActionRegistry.hpp"

using namespace MoleCuilder;

ActionQueue::ActionQueue() :
    AR(new ActionRegistry()),
    history(new ActionHistory)
{}

ActionQueue::~ActionQueue()
{
  delete history;
  delete AR;
}

Action* ActionQueue::getActionByName(const std::string &name)
{
  return AR->getActionByName(name);
}

bool ActionQueue::isActionKnownByName(const std::string &name) const
{
  return AR->isActionPresentByName(name);
}

void ActionQueue::registerAction(Action *_action)
{
  AR->registerInstance(_action);
}

const ActionTrait& ActionQueue::getActionsTrait(const std::string &name) const
{
  // this const_cast is just required as long as we have a non-const getActionByName
  const Action * const action = const_cast<ActionQueue *>(this)->getActionByName(name);
  return action->Traits;
}

void ActionQueue::addElement(Action* _Action,ActionState::ptr _state)
{
  history->addElement(_Action, _state);
}

void ActionQueue::clear()
{
  history->clear();
}


const ActionQueue::ActionTokens_t ActionQueue::getListOfActions() const
{
  ActionTokens_t returnlist;

  returnlist.insert(
      returnlist.end(),
      MapKeyConstIterator<ActionRegistry::const_iterator>(AR->getBeginIter()),
      MapKeyConstIterator<ActionRegistry::const_iterator>(AR->getEndIter()));

  return returnlist;
}

void ActionQueue::undoLast()
{
	history->undoLast();
}

void ActionQueue::redoLast()
{
	history->redoLast();
}


CONSTRUCT_SINGLETON(ActionQueue)
