/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MoleculeQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"

#include "molecule.hpp"
#include "World.hpp"


QtDialog::MoleculeQtQuery::MoleculeQtQuery(Parameter<const molecule *> &_param, const std::string &_title, const std::string &_description, QBoxLayout *_parent,Dialog *_dialog) :
    QtQuery<const molecule *>(_param, _title, _description),
    parent(_parent),
    dialog(_dialog)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  titleLabel->setToolTip(QString(getDescription().c_str()));
  inputBox = new QComboBox();
  // add all molecules to the combo box
  vector<const molecule*> molecules =
      const_cast<const World &>(World::getInstance()).getAllMolecules();
  for(vector<const molecule*>::const_iterator iter  = molecules.begin();
      iter != molecules.end();
      ++iter) {
    std::stringstream sstr;
    sstr << (*iter)->IndexNr << "\t" << (*iter)->getName();
    inputBox->addItem(QString(sstr.str().c_str()),QVariant((*iter)->IndexNr));
  }
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  connect(inputBox,SIGNAL(currentIndexChanged(int)),this,SLOT(onUpdate(int)));
}

QtDialog::MoleculeQtQuery::~MoleculeQtQuery()
{
}

void QtDialog::MoleculeQtQuery::onUpdate(int newIndex) {
  QVariant data = inputBox->itemData(newIndex);
  int idx = data.toInt();
  temp = World::getInstance().getMolecule(MoleculeById(idx));
  dialog->update();
}

