/*
 * FragmentationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/FragmentationAction/FragmentationAction.hpp"
#include "CommandLineParser.hpp"
#include "atom.hpp"
#include "config.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "stackclass.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char FragmentationFragmentationAction::NAME[] = "subspace-dissect";

FragmentationFragmentationAction::FragmentationFragmentationAction() :
  Action(NAME)
{}

FragmentationFragmentationAction::~FragmentationFragmentationAction()
{}

Action::state_ptr FragmentationFragmentationAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr FragmentationFragmentationAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr FragmentationFragmentationAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool FragmentationFragmentationAction::canUndo() {
  return false;
}

bool FragmentationFragmentationAction::shouldUndo() {
  return false;
}

const string FragmentationFragmentationAction::getName() {
  return NAME;
}
