/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ControllerOptions_MPQCCommandJob.cpp
 *
 *  Created on: Jun 6, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"

#include "ControllerOptions_MPQCCommandJob.hpp"

int ControllerOptions_MPQCCommandJob::parseExecutable(boost::program_options::variables_map &vm) {
  if (command == "addjobs") {
    if (!vm.count("executable")) {
      ELOG(1, "'"+command+"' requires two options: [executable] [jobcommand].");
      return 255;
    }
    executable = vm["executable"].as< std::string >();
  }
  return 0;
}

int ControllerOptions_MPQCCommandJob::parseFragmentpath(boost::program_options::variables_map &vm) {
  if (command == "receivempqc") {
    if (!vm.count("fragment-path")) {
      ELOG(1, "'"+command+"' requires two options: [fragment-path].");
      return 255;
    }
    fragmentpath = vm["fragment-path"].as< std::string >();
  }
  return 0;
}

int ControllerOptions_MPQCCommandJob::parseJobfiles(boost::program_options::variables_map &vm) {
  if (command == "addjobs") {
    if (!vm.count("jobfiles")) {
      ELOG(1, "'"+command+"' requires two options: [executable] [jobfiles].");
      return 255;
    }
    jobfiles = vm["jobfiles"].as< std::vector<std::string> >();
  }
  return 0;
}

