/*
 * MPQCJob.hpp
 *
 *  Created on: Feb 05, 2012
 *      Author: heber
 */

#ifndef MPQCCOMMANDJOB_HPP_
#define MPQCCOMMANDJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/serialization/export.hpp>

#include <string>

#include "JobMarket/Results/FragmentResult.hpp"
#include "JobMarket/Jobs/SystemCommandJob.hpp"

#include "Jobs/MPQCCommandJob_MPQCData.hpp"

class MPQCCommandJobTest;

/** This class calls mpqc for solving a specific Hartree Fock problem.
 *
 */
class MPQCCommandJob : public SystemCommandJob
{
  //!> grant unit test access
  friend class MPQCCommandJobTest;
public:
  MPQCCommandJob(const std::string &_inputfile, const JobId_t _JobId, const std::string &_command = std::string("mpqc"));
  ~MPQCCommandJob();

  bool operator==(const MPQCCommandJob &other) const;

  bool operator!=(const MPQCCommandJob &other) const {
    return !(*this == other);
  }

private:
  //!> private default cstor only for serializatio
  MPQCCommandJob();

  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<SystemCommandJob>(*this);
    ar & data;
  }

private:
  //!> class that contains energy and forces and serialization capabilities
  MPQCData data;

  FragmentResult::ptr extractResult(const std::string &resultstring);
  static const std::string keyword_hartreefock_energy;
  static const std::string keyword_hartreefock_forces;
  static const std::string keyword_moellerplesset_energy;
  static const std::string keyword_moellerplesset_forces;
};

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(MPQCCommandJob)

#endif /* MPQCCOMMANDJOB_HPP_ */
