/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RangeUnitTest.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "RangeUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( RangeTest );


void RangeTest::setUp()
{
  testrange = new range<int>(5,20);
};


void RangeTest::tearDown()
{
  delete testrange;
};

/** UnitTest for inRangeTest().
 */
void RangeTest::inRangeTest()
{
  // check valid range
  for (int i=5; i<20; i++)
    CPPUNIT_ASSERT(testrange->isInRange(i));

  // check negative range
  for (int i=-5; i>-20; i--)
    CPPUNIT_ASSERT(!testrange->isInRange(i));

  // lower limit-1 and upper limit are out of range
  CPPUNIT_ASSERT(!testrange->isInRange(4));
  CPPUNIT_ASSERT(!testrange->isInRange(20));

  // isBefore
  for (int i=4; i>=0; i--)
    CPPUNIT_ASSERT(testrange->isBefore(i));

  // isBeyond
  for (int i=20; i<30; i++)
    CPPUNIT_ASSERT(testrange->isBeyond(i));

}

/** UnitTest for operatorTest().
 */
void RangeTest::operatorTest()
{
  // check makeRange
  range<int> true_comparison = makeRange(5,20);
  range<int> false_comparison1 = makeRange(6,20);
  range<int> false_comparison2 = makeRange(5,21);
  range<int> false_comparison3 = makeRange(6,21);
  CPPUNIT_ASSERT_EQUAL(testrange->first, true_comparison.first);
  CPPUNIT_ASSERT_EQUAL(testrange->last, true_comparison.last);

  // check operator==
  CPPUNIT_ASSERT(*testrange == true_comparison);
  // check operator!=
  CPPUNIT_ASSERT(*testrange != false_comparison1);
  CPPUNIT_ASSERT(*testrange != false_comparison2);
  CPPUNIT_ASSERT(*testrange != false_comparison3);

  // check operator<
  CPPUNIT_ASSERT(!(*testrange < true_comparison));
  CPPUNIT_ASSERT(*testrange < false_comparison1);
  CPPUNIT_ASSERT(*testrange < false_comparison2);
  CPPUNIT_ASSERT(*testrange < false_comparison3);
  // check operator>
  CPPUNIT_ASSERT(!(*testrange > true_comparison));
  CPPUNIT_ASSERT(false_comparison1 > *testrange);
  CPPUNIT_ASSERT(false_comparison2 > *testrange);
  CPPUNIT_ASSERT(false_comparison3 > *testrange);
  // check operator>=,<=
  CPPUNIT_ASSERT(*testrange >= true_comparison);
  CPPUNIT_ASSERT(*testrange <= true_comparison);
}
