/*
 * QtUIFactory.hpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#ifndef QTUIFACTORY_HPP_
#define QTUIFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "UIElements/UIFactory.hpp"

#include <boost/thread.hpp>
#include <string>
#include <vector>

class QApplication;

class QtUIFactory : public UIFactory
{
  friend class UIFactory;

public:
  virtual ~QtUIFactory();

  virtual Dialog* makeDialog(const std::string &_title);
  virtual MainWindow* makeMainWindow();

  struct description : public UIFactory::factoryDescription {
    description(int _argc, char **_argv);
    virtual ~description();

    virtual UIFactory* makeFactory();

  private:
    int argc;
    char **argv;
 };
  virtual std::string getUIName(){  return "Qt4";  }

  static bool isTestMode(const char *_argument);

protected:
  QtUIFactory(int _argc, char **_argv);

private:

  void testrun(const std::vector<std::string> _scripts) const;

  void testlauncher_sleep(const boost::posix_time::time_duration& _period) const;

private:
  QApplication *app;

  int argc;
  char **argv;

  //!> internal flag to tell testlauncher_thread to stop
  mutable bool testlauncher_Interrupted;

  //!> internal thread to call Actions
  boost::thread *testlauncher_thread;
};

#endif /* QTUIFACTORY_HPP_ */
