/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtElementList.cpp
 *
 *  Created on: Mar 6, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Views/Qt4/QtElementList.hpp"

#include <iostream>

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "Formula.hpp"
#include "molecule.hpp"
#include "MoleculeListClass.hpp"

#include "Element/element.hpp"
#include "Element/periodentafel.hpp"

using namespace std;

const int QtElementList::COLUMNCOUNT = COLUMNTYPES_MAX;
const char *QtElementList::COLUMNNAMES[QtElementList::COLUMNCOUNT]={"Number","Name","Symbol","Mass"};

QtElementList::QtElementList(QWidget * _parent) :
    QTableWidget (_parent),
    Observer("QtElementList")
{
	setColumnCount(COLUMNCOUNT);

	for(int i=0; i<COLUMNCOUNT;++i) {
		QTableWidgetItem *heading = new QTableWidgetItem();
		std::cout << "Creating heading item " << heading << "." << std::endl;
		heading->setText(QString(COLUMNNAMES[i]));
		setHorizontalHeaderItem(i,heading);
	}

	molecules = World::getInstance().getMolecules();
	molecules->signOn(this);
	update(molecules);

  setRowCount(20);
  periodentafel *&periode = World::getInstance().getPeriode();
  //for(periodentafel::iterator it = periode->begin(); it < periode->end(); it ++){}

  int i=0;
  for (int ni=1;ni<200;ni++){
    const element *e = periode->FindElement(ni);
    if (e){

      QTableWidgetItem *indexWidget = new QTableWidgetItem();
      //std::cout << "Creating index item " << indexWidget << "." << std::endl;
      indexWidget->setText(QString::number(e->getAtomicNumber()));
      indexWidget->setData(Qt::UserRole,QVariant(e->getAtomicNumber()));
      setVerticalHeaderItem(i,indexWidget);

      const string name = e->getName();
      QTableWidgetItem *nameWidget = new QTableWidgetItem();
      //std::cout << "Creating name item " << nameWidget << " at " << i << "," << NAME << "." << std::endl;
      nameWidget->setText(QString(name.c_str()));
      setItem(i,NAME,nameWidget);

      const string symbol = e->getSymbol();
      QTableWidgetItem *symWidget = new QTableWidgetItem();
      //std::cout << "Creating name item " << nameWidget << " at " << i << "," << NAME << "." << std::endl;
      symWidget->setText(QString(symbol.c_str()));
      setItem(i,SYMBOL,symWidget);

      const double mass = e->getMass();
      QTableWidgetItem *massWidget= new QTableWidgetItem();
      //std::cout << "Creating count item " << countWidget << " at " << i << "," << ATOMCOUNT << "." << std::endl;
      massWidget->setText(QString::number(mass));
      massWidget->setFlags(Qt::ItemIsSelectable | Qt::ItemIsUserCheckable | Qt::ItemIsEnabled);
      setItem(i,MASS,massWidget);

      i ++;
    }
  }

	connect(this,SIGNAL(cellChanged(int,int)),this,SLOT(moleculeChanged(int,int)));
	connect(this,SIGNAL(cellClicked(int,int)),this,SLOT(cellSelected(int,int)));
}

QtElementList::~QtElementList()
{
	molecules->signOff(this);
}

void QtElementList::update(Observable *publisher) {
}

void QtElementList::subjectKilled(Observable *publisher) {
}

void QtElementList::moleculeChanged(int row, int column) {
}


void QtElementList::cellSelected(int row, int column)
{
}

