/*
 * QtMainWindow.hpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#ifndef QTMAINWINDOW_HPP_
#define QTMAINWINDOW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "UIElements/MainWindow.hpp"
#include <QtGui/QMainWindow>

#include <map>
#include <set>

#include "Menu/Qt4/QtMenu.hpp"

class QtWorldView;
class QtElementList;
class StringView;
class GLWorldView;
class QtMoleculeView;
class QtStatusBar;

class QtMainWindow : public QMainWindow, public MainWindow
{
  Q_OBJECT

public:
  QtMainWindow(QApplication *_theApp);
  virtual ~QtMainWindow();

  virtual void display();


private:
  // All kinds of QTStuff used in this window
  QApplication *theApp;
  QtWorldView *worldDisplay;
  QtElementList *elementList;
  GLWorldView *molecule3dDisplay;
  QtMoleculeView *moleculeDisplay;
  QtStatusBar *statusBar;
  QtMenu<QMenuBar> *MainMenu;

};

#endif /* QTMAINWINDOW_HPP_ */
