/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtMainWindow.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "QtMainWindow.hpp"

#include<Qt/qapplication.h>
#include<Qt/qlabel.h>
#include<Qt/qstring.h>
#include<Qt/qmenubar.h>
#include<Qt/qsplitter.h>

#include<iostream>
#include<map>

#include<boost/bind.hpp>

#include "Menu/Qt4/QtMenu.hpp"
#include "Views/Qt4/QtWorldView.hpp"
#include "Views/Qt4/QtElementList.hpp"
#include "Views/Qt4/QtMoleculeView.hpp"
#include "Views/Qt4/QtStatusBar.hpp"
#include "Views/Qt4/Qt3D/GLWorldView.hpp"

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ValueStorage.hpp"

QtMainWindow::QtMainWindow(QApplication *_theApp) :
    theApp(_theApp)
{
  QSplitter *splitter1 = new QSplitter (Qt::Horizontal, this );
  QSplitter *splitter2 = new QSplitter (Qt::Vertical, splitter1 );
  QTabWidget *worldTab = new QTabWidget(splitter2);

  worldDisplay = new QtWorldView(worldTab);
  elementList = new QtElementList(worldTab);

  moleculeDisplay = new QtMoleculeView();
  molecule3dDisplay = new GLWorldView(this);
//  molecule3dDisplay->setSizePolicy( QSizePolicy::Minimum,QSizePolicy::Minimum);
  molecule3dDisplay->setMinimumSize( QSize(640,480) );
//  molecule3dDisplay->setFocus();
  molecule3dDisplay->camera()->setEye( QVector3D(0,3,10));

  MainMenu = new QtMenu<QMenuBar>(menuBar(), "");
  MainMenu->init();

  setCentralWidget(splitter1);
  splitter1->addWidget(splitter2);
  splitter1->addWidget(moleculeDisplay);
  splitter2->addWidget(molecule3dDisplay);
  splitter2->addWidget(worldTab);
  worldTab->addTab(worldDisplay, "Molecules");
  worldTab->addTab(elementList, "All Elements");

  statusBar = new QtStatusBar(this);
  setStatusBar(statusBar);

  connect(worldDisplay,SIGNAL(moleculeSelected(molecule*)),moleculeDisplay,SLOT(moleculeSelected(molecule*)));
  connect(worldDisplay,SIGNAL(moleculeUnSelected(molecule*)),moleculeDisplay,SLOT(moleculeUnSelected(molecule*)));
}

QtMainWindow::~QtMainWindow()
{
  menuBar()->clear();
  delete MainMenu;
}

void QtMainWindow::display() {
  this->show();
  theApp->exec();
}

