/*
 * RandomNumberGenerator.hpp
 *
 *  Created on: Dec 31, 2010
 *      Author: heber
 */

#ifndef RANDOMNUMBERGENERATOR_HPP_
#define RANDOMNUMBERGENERATOR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class RandomNumberDistribution;
class RandomNumberEngine;


/** Abstract base class for a random number generator.
 *
 *  This class represents the interface to the random number generators.
 *  Hence, they all can be accessed the same way.
 *
 * It is also the base class that is needed for RandomNumberGeneratorFactory.
 */
class RandomNumberGenerator
{
public:
  /** obtain a random number via generator and the specific distribution.
   *
   */
  virtual double operator()() const =0;

  /** Set the generator's seed.
   *
   * @param _seed seed to set to
   */
  virtual void seed(unsigned int _seed)=0;

  /** Getter for smallest possible random number
   *
   * @return smallest possible random number
   */
  virtual double min() const=0;

  /** Getter for largest possible random number
   *
   * @return largest possible random number
   */
  virtual double max() const=0;

  /** Getter for the type name of the internal engine.
   *
   */
  virtual std::string EngineName() const=0;

  /** Getter for the type name of the internal distribution.
   *
   */
  virtual std::string DistributionName() const=0;

  /** Destructor of class RandomNumberGenerator.
   *
   * @note must be public such that instances from factory can be destroyed.
   *
   */
  virtual ~RandomNumberGenerator();

protected:
  /** Constructor of class RandomNumberGenerator.
   *
   * @note is protected such that instances can only be created by the factory.
   */
  RandomNumberGenerator();

  // we place them here such that they can be made friend of these
  // classes and are granted access to dstor
  RandomNumberEngine *engine_type;
  RandomNumberDistribution *distribution_type;

};

#endif /* RANDOMNUMBERGENERATOR_HPP_ */
