/*
 * ObservedValuesContainer_impl.hpp
 *
 *  Created on: Oct 29, 2015
 *      Author: heber
 */


#ifndef OBSERVEDVALUESCONTAINER_IMPL_HPP_
#define OBSERVEDVALUESCONTAINER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ObservedValuesContainer.hpp"

#include "CodePatterns/Assert.hpp"

template <class T, typename id>
ObservedValuesContainer<T,id>::ObservedValuesContainer(
    const std::string _name,
    QtObservedInstanceBoard &_board,
    const onDestroy_t _onDestroy) :
  NameOfType(_name),
  board(_board),
  onDestroy(_onDestroy)
{}

template <class T, typename id>
ObservedValuesContainer<T,id>::~ObservedValuesContainer()
{
  for (typename CountedObservedValues_t::iterator iter = ObservedValues.begin();
      iter != ObservedValues.end(); ++iter) {
    ASSERT( !iter->second.empty(),
        "~ObservedValuesContainer() of "+NameOfType+" "+toString(iter->first)
        +" has an empty list in ObservedValues.");
    for (typename RefCountedObservedValues_t::iterator listiter = iter->second.begin();
        listiter != iter->second.end(); ++listiter) {
      listiter->first->noteBoardIsGone();
    }
  }
}

template <class T, typename id>
typename T::ptr ObservedValuesContainer<T,id>::get(const id _id)
{
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT( iter != ObservedValues.end(),
      "ObservedValuesContainer::getObservedValues() - no observed values present for "
      +NameOfType+" "+toString(_id));
  ASSERT( !iter->second.empty(),
      "ObservedValuesContainer<T,id>::get() of "+NameOfType+" "+toString(_id)
      +" has an empty list in ObservedValues.");
  const typename T::ptr &obsvalues = iter->second.back().first;

  return obsvalues;
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::markObservedValuesAsConnected(
    const id _id)
{
  LOG(3, "DEBUG: ObservedValuesContainer got markObservedValuesAsConnected() for an observed value of "
      << NameOfType << " " << _id);
 typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT (iter != ObservedValues.end(),
      "ObservedValuesContainer<T,id>::markObservedValuesAsConnected() - Observed value of "
      +NameOfType+" "+toString(_id)+" is not present yet.");
  ASSERT( !iter->second.empty(),
      "ObservedValuesContainer<T,id>::markObservedValuesAsConnected() of "+NameOfType
      +" "+toString(_id)+" has an empty list in ObservedValues.");
  ++(iter->second.back().second);
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::checkRefCount(
    const id _id) const
{
  typename CountedObservedValues_t::const_iterator iter = ObservedValues.find(_id);
  ASSERT( !iter->second.empty(),
      "ObservedValuesContainer<T,id>::checkRefCount() of "+NameOfType
      +" "+toString(_id)+" has an empty list in ObservedValues.");
  return ((iter != ObservedValues.end()) && (iter->second.front().second == 0));
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::markObservedValuesAsDisconnected(
    const id _id)
{
  LOG(3, "DEBUG: ObservedValuesContainer got markObservedValuesAsDisconnected() for an observed value of "
      << NameOfType << " " << _id);
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT (iter != ObservedValues.end(),
      "ObservedValuesContainer<T,id>::markObservedValuesAsDisconnected() - Observed value of "
      +NameOfType+" "+toString(_id)+" is not present yet.");
  ASSERT( !iter->second.empty(),
      "ObservedValuesContainer<T,id>::markObservedValuesAsDisconnected() of "+NameOfType
      +" "+toString(_id)+" has an empty list in ObservedValues.");
  ASSERT (iter->second.front().second != 0,
      "ObservedValuesContainer<T,id>::markObservedValuesAsDisconnected() - Observed value of "
      +NameOfType+" "+toString(_id)+" is already signOff() from all.");
  --(iter->second.front().second);

  if (checkRefCount(_id) && checksubjectKilled(_id) && checkMarkedForErase(_id))
    removeObservedValues(_id);
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::checksubjectKilled(
    const id _id) const
{
  typename subjectKilledCount_t::const_iterator iter = subjectKilledCount.find(_id);
  return ((iter != subjectKilledCount.end()) && (iter->second == T::MAX_ObservedTypes));
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::countsubjectKilled(const id _id)
{
  LOG(3, "DEBUG: ObservedValuesContainer got subjectKilled() for an observed value of "
      << NameOfType << " " << _id);
  typename subjectKilledCount_t::iterator iter = subjectKilledCount.find(_id);
  if (iter == subjectKilledCount.end()) {
    std::pair<typename subjectKilledCount_t::iterator, bool> inserter =
        subjectKilledCount.insert( std::make_pair(_id, 0) );
    iter = inserter.first;
  }
  ASSERT (iter->second < T::MAX_ObservedTypes,
      "ObservedValuesContainer<T,id>::countsubjectKilled() - all subjectKilled() for "
      +NameOfType+" "+toString(_id)+" for each observed channel came in already.");
  ++(iter->second);

  if (checkRefCount(_id) && checksubjectKilled(_id) && checkMarkedForErase(_id))
    removeObservedValues(_id);
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::removeObservedValues(const id _id)
{
  LOG(3, "DEBUG: ObservedValuesContainer removes " << NameOfType << " " << _id);
  // call callback function
  onDestroy(_id);
  subjectKilledCount.erase(_id);
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT( !iter->second.empty(),
      "ObservedValuesContainer<T,id>::removeObservedValues() of "+NameOfType
      +" for "+toString(_id)+" has an empty list in ObservedValues.");
  if (iter->second.size() == 1)
    ObservedValues.erase(iter);
  else {
    //if more than one, erase always the first one
    iter->second.pop_front();
  }
  MarkedForErase.erase(_id);
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::eraseObservedValues(const id _id)
{
#ifndef NDEBUG
  std::pair< typename std::set<id>::iterator, bool > inserter =
#endif
  MarkedForErase.insert(_id);
  ASSERT( inserter.second,
      "ObservedValuesContainer<T,id>::eraseObservedValues() - received twice for "
      +NameOfType+" "+toString(_id)+".");

  if (checkRefCount(_id) && checksubjectKilled(_id) && checkMarkedForErase(_id))
    removeObservedValues(_id);
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::checkMarkedForErase(const id _id) const
{
  return MarkedForErase.count(_id);
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::insert(const id _id, const typename T::ptr &_obsvalues)
{
  std::pair<typename CountedObservedValues_t::iterator, bool> inserter =
      ObservedValues.insert(
          std::make_pair( _id, RefCountedObservedValues_t(1,std::make_pair(_obsvalues,0)) ) );
  if (!inserter.second) {
    // already an entry present? add to deque
    inserter.first->second.push_back( std::make_pair(_obsvalues,0) );
  }
  _obsvalues->activateObserver();
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::changeIdentifier(const id _oldid, const id _newid)
{
  const typename CountedObservedValues_t::iterator Colditer = ObservedValues.find(_oldid);
  const typename CountedObservedValues_t::iterator Cnewiter = ObservedValues.find(_newid);
  const typename subjectKilledCount_t::iterator Solditer = subjectKilledCount.find(_oldid);
  const typename subjectKilledCount_t::iterator Snewiter = subjectKilledCount.find(_newid);
  const typename MarkedForErase_t::iterator Eolditer = MarkedForErase.find(_oldid);
  const typename MarkedForErase_t::iterator Enewiter = MarkedForErase.find(_newid);
  bool status = ((Colditer != ObservedValues.end()) && (Cnewiter == ObservedValues.end()));
  status &= ((Solditer != subjectKilledCount.end()) && (Snewiter == subjectKilledCount.end()));
  status &= ((Eolditer != MarkedForErase.end()) && (Enewiter == MarkedForErase.end()));
  // change id here only if still present
  if (status) {
    {
      // TODO: Actually, we need to think whether we do not have to to split the
      // deque in two parts: the last entry having the newid, while all other
      // ones retain the old one until they get removed. But we need to check
      // whether changing ids "there" is possible when the QtObserved... is under
      // removal.
      RefCountedObservedValues_t obsvalues = Colditer->second;
      ObservedValues.erase(Colditer);
      ObservedValues.insert( std::make_pair(_newid, obsvalues) );
    }
    {
      const size_t countvalue = Solditer->second;
      subjectKilledCount.erase(Solditer);
      subjectKilledCount.insert( std::make_pair(_newid, countvalue) );
    }
    {
      MarkedForErase.erase(Eolditer);
      MarkedForErase.insert(_newid);
    }
    return true;
  } else
    return false;
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::isPresent(const id _id) const
{
  typename CountedObservedValues_t::const_iterator iter = ObservedValues.find(_id);
  return (iter != ObservedValues.end());
}

#endif /* OBSERVEDVALUESCONTAINER_IMPL_HPP_ */
