/*
 * QSeisPlot.cpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/Plotting/QSeisPlot.hpp"
#include "UIElements/Views/Qt4/Plotting/XMLParser/QSeisXMLParser.hpp"
#include "UIElements/Views/Qt4/Plotting/XMLParser/QSeisXMLParser_plottype.hpp"

#include <iostream>
#include <qwt_plot_marker.h>

// have this after(!) all Qt includes
#include "CodePatterns/MemDebug.hpp"

QSeisPlot::QSeisPlot(QWidget *parent,QString type) : QwtPlot(parent)
{
    //no title as there are already the different tabs
    setTitle("");
    //display legend on the right hand side
    //no legend displayed - list names are colored instead
    //insertLegend(new QwtLegend(), QwtPlot::RightLegend);

    {
      const std::string name("energy");
      const std::string xlabel("Distance");
      const std::string ylabel("Energy");
      const std::string style("");
      const std::vector<int> xunits;
      const std::vector<int> yunits;
      const std::vector<std::string> unitnames;
      const std::map<std::string,std::string> unitmap;
      m_plottype = new plottype(name,xlabel,ylabel,style,xunits,yunits, unitnames,unitmap);
    }
//    plottype* tmp = QSeisXMLParser::getInstance().return_plottype_by_name(type.toStdString());
    ASSERT(m_plottype != NULL,
        "QSeisPlot::QSeisPlot() - could not find desired plottype by name "+type.toStdString()+".");
//    std::cout << "Type is " << type.toStdString() << ", " << m_plottype << std::endl;

    //label axes
    const std::string xlabel = m_plottype->get_label(plottype::X);
    const std::string ylabel = m_plottype->get_label(plottype::Y);
    const std::string xunits = m_plottype->get_units(plottype::X);
    const std::string yunits = m_plottype->get_units(plottype::Y);
    setAxisTitle(xBottom, (xlabel+std::string(" [")+xunits+std::string("]")).c_str());
    setAxisTitle(yLeft, (ylabel+std::string(" [")+yunits+std::string("]")).c_str());

    //add zero line
    QwtPlotMarker *zeroLine = new QwtPlotMarker();
    zeroLine->setLineStyle(QwtPlotMarker::HLine);
    zeroLine->setYValue(0.0);
    zeroLine->attach(this);

    zoomer = new ScrollZoomer(canvas());

#ifdef QWTPANNER
    panner = new QwtPlotPanner(canvas());
    panner->setMouseButton(Qt::MidButton);
#else
    panning = false;
    startPan = QPointF(0.0f, 0.0f);
#endif

    //init colors
    availableColors.append(QColor(Qt::darkYellow));
    availableColors.append(QColor(Qt::darkMagenta));
    availableColors.append(QColor(Qt::darkCyan));
    availableColors.append(QColor(Qt::darkGreen));
    availableColors.append(QColor(Qt::darkRed));
    availableColors.append(QColor(Qt::yellow));
    availableColors.append(QColor(Qt::magenta));
    availableColors.append(QColor(Qt::cyan));
    availableColors.append(QColor(Qt::green));
    availableColors.append(QColor(Qt::red));
    availableColors.append(QColor(Qt::blue));
    availableColors.append(QColor(Qt::black));

    color_map.insert(std::make_pair("black",QColor(Qt::black)));
    color_map.insert(std::make_pair("red",QColor(Qt::red)));
    color_map.insert(std::make_pair("blue",QColor(Qt::blue)));
    color_map.insert(std::make_pair("green",QColor(Qt::green)));
    color_map.insert(std::make_pair("cyan",QColor(Qt::cyan)));
    color_map.insert(std::make_pair("yellow",QColor(Qt::yellow)));
    color_map.insert(std::make_pair("magenta",QColor(Qt::magenta)));
    color_map.insert(std::make_pair("darkYellow",QColor(Qt::darkYellow)));
    color_map.insert(std::make_pair("darkMagenta",QColor(Qt::darkMagenta)));
    color_map.insert(std::make_pair("darkCyan",QColor(Qt::darkCyan)));
    color_map.insert(std::make_pair("darkGreen",QColor(Qt::darkGreen)));
    color_map.insert(std::make_pair("darkRed",QColor(Qt::darkRed)));
}

QSeisPlot::~QSeisPlot()
{
  delete m_plottype;
}

void QSeisPlot::loadSettingsFromXML(QString fileName)
{
    //load settings from XML file sometime in the future
    qDebug("loadSettingsFromXML %s", fileName.toAscii().constData());
}

void QSeisPlot::resetZoomer()
{
    if (axisAutoScale(xBottom) && axisAutoScale(yLeft))
        zoomer->setZoomBase(0);
}

#ifndef QWTPANNER
void QSeisPlot::mouseMoveEvent(QMouseEvent *event)
{
    if ((event->buttons() == Qt::MidButton) && (panning))
    {
        double xPos = invTransform(xBottom, event->pos().x() - canvas()->pos().x());
        double yPos = invTransform(yLeft, event->pos().y() - canvas()->pos().y());
        zoomer->moveBy(xPos-startPan.x(), yPos-startPan.y());
        startPan = QPointF(xPos, yPos);
    }
}

void QSeisPlot::mousePressEvent(QMouseEvent *event)
{
    //start panning only above the plot canvas
    if ((event->button() == Qt::MidButton)
        && (event->pos().x() >= canvas()->pos().x())
        && (event->pos().x() <= (canvas()->pos().x() + canvas()->width()))
        && (event->pos().y() >= canvas()->pos().y())
        && (event->pos().y() <= (canvas()->pos().y() + canvas()->height())))
    {
        panning = true;
        startPan = QPointF(invTransform(xBottom, event->pos().x() - canvas()->pos().x()),
                           invTransform(yLeft, event->pos().y() - canvas()->pos().y()));
    }
}

void QSeisPlot::mouseReleaseEvent(QMouseEvent *event)
{
    if (event->button() == Qt::MidButton)
    {
        panning = false;
        startPan = QPointF(0.0f, 0.0f);
    }
}
#endif

QColor QSeisPlot::getCurveColor(std::string curve_color)
{
	if(color_map.count(curve_color)!=0) {
		if(availableColors.count(color_map[curve_color])!=0) {
			return color_map[curve_color];
		}
	}
	QColor retColor = QColor(Qt::black);
	if (!availableColors.isEmpty())
	{
	     retColor = availableColors.last();
		 availableColors.removeLast();
		 }

	return retColor;
}

void QSeisPlot::freeCurveColor(QColor color)
{
    if (color != QColor(Qt::black) && (!availableColors.contains(color)))
    {
        availableColors.append(color);
    }
}

void QSeisPlot::resetPlot()
{
    setAxisAutoScale(QwtPlot::xBottom);
    setAxisAutoScale(QwtPlot::yLeft);
    replot();
    zoomer->setZoomBase(0);
}
