/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TextDialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "TextUI/TextDialog.hpp"
#include "TextUI/Query/TextQuery.hpp"

using namespace std;


TextDialog::TextDialog()
{
}

TextDialog::~TextDialog()
{
}

void TextDialog::queryEmpty(const char* title, std::string description){
  registerQuery(new EmptyTextQuery(title,description));
}

void TextDialog::queryBoolean(const char* title, std::string description){
  registerQuery(new BooleanTextQuery(title,description));
}

void TextDialog::queryInt(const char* title, std::string description){
  registerQuery(new IntTextQuery(title,description));
}

void TextDialog::queryInts(const char* title, std::string description){
  registerQuery(new IntsTextQuery(title,description));
}

void TextDialog::queryUnsignedInt(const char* title, std::string description){
  registerQuery(new UnsignedIntTextQuery(title,description));
}

void TextDialog::queryUnsignedInts(const char* title, std::string description){
  registerQuery(new UnsignedIntsTextQuery(title,description));
}

void TextDialog::queryDouble(const char* title, std::string description){
  registerQuery(new DoubleTextQuery(title,description));
}

void TextDialog::queryDoubles(const char* title, std::string description){
  registerQuery(new DoublesTextQuery(title,description));
}

void TextDialog::queryString(const char* title, std::string description){
  registerQuery(new StringTextQuery(title,description));
}

void TextDialog::queryStrings(const char* title, std::string description){
  registerQuery(new StringsTextQuery(title,description));
}

void TextDialog::queryAtom(const char* title, std::string description) {
  registerQuery(new AtomTextQuery(title,description));
}

void TextDialog::queryAtoms(const char* title, std::string description) {
  registerQuery(new AtomsTextQuery(title,description));
}

void TextDialog::queryMolecule(const char* title, std::string description) {
  registerQuery(new MoleculeTextQuery(title,description));
}

void TextDialog::queryMolecules(const char* title, std::string description) {
  registerQuery(new MoleculesTextQuery(title,description));
}

void TextDialog::queryVector(const char* title, bool check, std::string description) {
  registerQuery(new VectorTextQuery(title,check,description));
}

void TextDialog::queryVectors(const char* title, bool check, std::string description) {
  registerQuery(new VectorsTextQuery(title,check,description));
}

void TextDialog::queryBox(const char* title, std::string description) {
  registerQuery(new BoxTextQuery(title,description));
}

void TextDialog::queryElement(const char* title, std::string description){
  registerQuery(new ElementTextQuery(title,description));
}

void TextDialog::queryElements(const char* title, std::string description){
  registerQuery(new ElementsTextQuery(title,description));
}

void TextDialog::queryFile(const char* title, std::string description){
  registerQuery(new FileTextQuery(title,description));
}

void TextDialog::queryRandomNumberDistribution_Parameters(const char* title, std::string description){
  registerQuery(new RandomNumberDistribution_ParametersTextQuery(title,description));
}

/************************** Query Infrastructure ************************/
/*       ---> shifted to folder Query                                   */
/************************************************************************/

