/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UnsignedIntTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::UnsignedIntTextQuery::UnsignedIntTextQuery(string title, std::string _description) :
    Dialog::UnsignedIntQuery(title,_description)
{}

TextDialog::UnsignedIntTextQuery::~UnsignedIntTextQuery() {}

bool TextDialog::UnsignedIntTextQuery::handle() {
  bool badInput = false;
  do{
    badInput = false;
    std::cout << getDescription() << ": ";
    std::cin >> tmp;
    if(std::cin.fail()){
      badInput=true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
    }
  } while(badInput);
  // clear the input buffer of anything still in the line
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return true;
}

