/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IntsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::IntsTextQuery::IntsTextQuery(string title, std::string _description) :
    Dialog::IntsQuery(title,_description)
{}

TextDialog::IntsTextQuery::~IntsTextQuery() {}

bool TextDialog::IntsTextQuery::handle() {
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  std::string::iterator olditer = line.begin();
  for(string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(string(iter, olditer));
      stream >> temp;
      tmp.push_back(temp);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(string(olditer, line.end()));
    stream >> temp;
    tmp.push_back(temp);
  }

  return true;
}

