/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"


TextDialog::ElementTextQuery::ElementTextQuery(std::string title, std::string _description) :
    Dialog::ElementQuery(title,_description)
{}

TextDialog::ElementTextQuery::~ElementTextQuery()
{}

bool TextDialog::ElementTextQuery::handle() {
  bool badInput=false;
  bool aborted = false;
  const element * temp = NULL;
  do{
    badInput = false;
    std::cout << getDescription() << ": ";

    // try to read as Atomic number
    int Z;
    std::cin >> Z;
    if(!std::cin.fail()){
      if(Z==-1){
        aborted = true;
      }
      else{
        temp = World::getInstance().getPeriode()->FindElement(Z);
        if(!temp){
          std::cout << "No element with this atomic number!" << std::endl;
          badInput = true;
        }
      }
      continue;
    }
    else{
      std::cin.clear();
    }

    // Try to read as shorthand
    // the last buffer content was not removed, so we read the
    // same thing again, this time as a std::string
    std::string shorthand;
    std::cin >> shorthand;
    if(!std::cin.fail()){
      if(shorthand.empty()){
        aborted = true;
      }
      else{
        temp = World::getInstance().getPeriode()->FindElement(shorthand.c_str());
        if(!temp){
          std::cout << "No element with this shorthand!" << std::endl;
          badInput = true;
        }
      }
    }
    else{
      std::cout << "Could not read input. Try Again." << std::endl;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      badInput = true;
    }

  }while(badInput);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return !aborted;
}

