/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ChangeElementAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomIdDescriptor.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "CodePatterns/Log.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "CodePatterns/Verbose.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <map>
#include <string>

#include "Actions/AtomAction/ChangeElementAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ChangeElementAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr AtomChangeElementAction::performCall() {
  atom *first = NULL;
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  // create undo state
  ElementMap Elements;
  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    Elements.insert(std::pair<int, const element *> (iter->second->getId(), iter->second->getType()));
  }
  AtomChangeElementState *UndoState = new AtomChangeElementState(Elements, params);

  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    first = iter->second;
    LOG(1, "Changing atom " << *first << " to element " << *params.elemental << ".");
    mol = first->getMolecule();
    first->removeFromMolecule(); // remove atom
    first->setType(params.elemental);
    mol->AddAtom(first);  // add atom to ensure correctness of formula
  }
  return Action::state_ptr(UndoState);
}

Action::state_ptr AtomChangeElementAction::performUndo(Action::state_ptr _state) {
  AtomChangeElementState *state = assert_cast<AtomChangeElementState*>(_state.get());
  atom *first = NULL;
  molecule *mol = NULL;

  for(ElementMap::const_iterator iter = state->Elements.begin(); iter != state->Elements.end(); ++iter) {
    first = World::getInstance().getAtom(AtomById(iter->first));
    mol = first->getMolecule();
    first->removeFromMolecule(); // remove atom
    first->setType(iter->second);
    mol->AddAtom(first);  // add atom to ensure correctness of formula
  }

  return Action::state_ptr(_state);
}

Action::state_ptr AtomChangeElementAction::performRedo(Action::state_ptr _state){
  AtomChangeElementState *state = assert_cast<AtomChangeElementState*>(_state.get());
  atom *first = NULL;
  molecule *mol = NULL;

  for(ElementMap::const_iterator iter = state->Elements.begin(); iter != state->Elements.end(); ++iter) {
    first = World::getInstance().getAtom(AtomById(iter->first));
    mol = first->getMolecule();
    first->removeFromMolecule(); // remove atom
    first->setType(state->params.elemental);
    mol->AddAtom(first);  // add atom to ensure correctness of formula
  }

  return Action::state_ptr(_state);
}

bool AtomChangeElementAction::canUndo() {
  return true;
}

bool AtomChangeElementAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
