/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AddAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomIdDescriptor.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AtomAction/AddAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AddAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr AtomAddAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // execute action
  atom * first = World::getInstance().createAtom();
  first->setType(params.elemental);
  first->setPosition(params.position);
  LOG(1, "Adding new atom with element " << first->getType()->getName() << " at " << (first->getPosition()) << ".");
  // TODO: remove when all of World's atoms are stored.
  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  if (!molecules.empty()) {
    std::vector<molecule *>::iterator iter = molecules.begin();
    (*iter)->AddAtom(first);
  }
  return Action::state_ptr(new AtomAddState(first->getId(), params));
}

Action::state_ptr AtomAddAction::performUndo(Action::state_ptr _state) {
  AtomAddState *state = assert_cast<AtomAddState*>(_state.get());

  LOG(1, "Removing atom with id " << state->id << ".");
  World::getInstance().destroyAtom(state->id);

  return Action::state_ptr(_state);
}

Action::state_ptr AtomAddAction::performRedo(Action::state_ptr _state){
  AtomAddState *state = assert_cast<AtomAddState*>(_state.get());

  atom * first = World::getInstance().createAtom();
  first->setType(state->params.elemental);
  first->setPosition(state->params.position);
  LOG(1, "Re-adding new atom with element " << state->params.elemental->getName() << " at " << state->params.position << ".");
  // TODO: remove when all of World's atoms are stored.
  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  if (!molecules.empty()) {
    std::vector<molecule *>::iterator iter = molecules.begin();
    (*iter)->AddAtom(first);
  }
  if (first->getId() != state->id)
    if (!first->changeId(state->id))
      return Action::failure;
  return Action::state_ptr(_state);
}

bool AtomAddAction::canUndo() {
  return true;
}

bool AtomAddAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
