#!/bin/bash
#


# launch me in the build directory!
test -e config.status || { echo "We must be in an (autotools) build directory."; exit 255; }
test -z "`./config.status --version | grep '\-\-prefix'`" || { echo "--prefix must not have been used."; exit 255; }

# check arguments
test ! -z $1 || { echo "$0 <package name>"; exit 255; }
packagename=$1

# check function for return codes
function check
{
	# 1 is the failing command's name
	if test $? != 0; then
		echo "$1 failed wih error code $?"
		exit $?
	fi
}

# create distribution archive
make dist
check dist

# find version
version=`ls ${packagename}-*.tar.gz | sort | tail -n 1 | sed -e "s#${packagename}-\(.*\).tar.gz#\1#"` 
check find_version
echo "Creating debian package of $packagename for version $version"

# rename archive to compliant name
mv -f ${packagename}-${version}.tar.gz ${packagename}_${version}.orig.tar.gz

# extract
rm -rf ${packagename}-${version}
tar -zxf ${packagename}_${version}.orig.tar.gz
check extract_archive

# enter and build
cores=4
cd ${packagename}-${version}
debuild -j${cores}
check debuild

# and exit
exit 0
