/*
 * ObservedValue_types.hpp
 *
 *  Created on: Oct 28, 2015
 *      Author: heber
 */


#ifndef OBSERVEDVALUE_TYPES_HPP_
#define OBSERVEDVALUE_TYPES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include <boost/any.hpp>

class Observer;

/** typedef for a vector of ObservedValue's (each is due to templating its
 * own type. Therefore, we need to use boost::any).
 */
typedef std::vector<boost::any> ObservedValues_t;

/** typedef for the permanent and (for the lifetime of the object) never
 * changing index.
 *
 * Note that this is slightly dangerous because two objects may get the same
 * index if one is destroyed and another one instantiated at the same address.
 */
typedef const Observer * ObservedValue_Index_t;


#endif /* OBSERVEDVALUE_TYPES_HPP_ */
