/*
 * streamFactory.hpp
 *
 *  Created on: Feb 27, 2016
 *      Author: heber
 */


#ifndef STREAMFACTORY_HPP_
#define STREAMFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>

/** Defines template interface for a factory class.
 *
 */
template <class T>
struct StreamFactory
{
  /** Static creator function for a single instance.
   *
   * \param _type specific type name
   * \param _input input stream that contains all information required to
   *        create the instance
   */
  T* createInstance(
      const std::string &_type,
      std::istream &_input) const;
};


#endif /* STREAMFACTORY_HPP_ */
