/*
 * StreamFactory_Particle.hpp
 *
 *  Created on: Feb 28, 2016
 *      Author: heber
 */


#ifndef STREAMFACTORY_PARTICLE_HPP_
#define STREAMFACTORY_PARTICLE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Potentials/StreamFactory.hpp"

template <>
struct StreamFactory<Particle>
{
  virtual ~StreamFactory<Particle>();

  /** Creates an instance of the requested particle.
   *
   * \param serialized stream to parser SerializablePotential from
   */
  Particle *createInstance(
      const std::string &,
      std::istream &serialized) const;

private:

  /** Helper function to get a default constructed particle.
   *
   * This has to be implemented by inheriting factory class.
   *
   * \return default constructed particle instance
   */
  virtual Particle* getDefaultParticle() const=0;

};

#endif /* STREAMFACTORY_PARTICLE_HPP_ */
