/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * StreamFactory_Particle_impl.hpp
 *
 *  Created on: Feb 28, 2016
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"

#include "Potentials/Exceptions.hpp"
#include "Potentials/Particles/Particle.hpp"
#include "Potentials/Particles/StreamFactory_Particle.hpp"

StreamFactory<Particle>::~StreamFactory<Particle>()
{}

Particle *
StreamFactory<Particle>::createInstance(
    const std::string &,
    std::istream &_input) const
{
  Particle * const particle = getDefaultParticle();
  try {
    particle->stream_from(_input);
  } catch (SerializerMissingValueException &e) {
    ELOG(1, "Missing value for particle in line " << e.what());
  }
  // when stream is empty (e.g. empty new line), atomic_number is not reset
  if (particle->atomic_number != (atomicNumber_t)-1)
    return particle;
  else
    return NULL;
}

