/*
 * ParticleFactory.hpp
 *
 *  Created on: Feb 27, 2016
 *      Author: heber
 */


#ifndef PARTICLEFACTORY_HPP_
#define PARTICLEFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "CodePatterns/Singleton.hpp"

#include "Potentials/Particles/Particle.hpp"
#include "Potentials/Particles/StreamFactory_Particle.hpp"
#include "types.hpp"

class ParticleFactory :
    public Singleton<ParticleFactory>,
    public StreamFactory<Particle>
{
  //!> make Singleton template friend
  friend class Singleton<ParticleFactory>;

protected:

  /** Implementing function for constructing default particle, required for
   * StreamFactory specialization.
   *
   * \return default constructed particle
   */
  virtual Particle* getDefaultParticle() const;

public:

  /** Static function to create a single particle instance.
   *
   * \param _type this is not needed for particles
   * \param _input stream from which to take parameters to instantiate
   */
  Particle * createInstance(
      const std::string &,
      std::istream &_input) const;

  /** Static function to create a single particle instance.
   *
   * \param _name name of particle
   * \param _element represented element
   * \param _charge (partial) charge of this particle
   */
  Particle * createInstance(
      const std::string &_name,
      const atomicNumber_t _element,
      const double _charge) const;

private:
  ParticleFactory () {}
  virtual ~ParticleFactory () {}
};

#endif /* PARTICLEFACTORY_HPP_ */
