/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParticleFactory.cpp
 *
 *  Created on: Feb 27, 2016
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ParticleFactory.hpp"

#include "CodePatterns/Singleton_impl.hpp"

#include "Potentials/Particles/Particle.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

#include "Potentials/Particles/ParticleRegistry.hpp"

Particle* ParticleFactory::getDefaultParticle() const
{
  periodentafel * const periode = World::getInstance().getPeriode();
  Particle * const particle = new Particle(*periode);
  return particle;
}

Particle *
ParticleFactory::createInstance(
    const std::string &_name,
    const atomicNumber_t _element,
    const double _charge) const
{
  periodentafel * const periode = World::getInstance().getPeriode();
  Particle * const particle = new Particle(*periode, _name, _element);
  particle->charge =_charge;

  // particle is already registered
//  ParticleRegistry::getInstance().registerInstance(particle);

  return particle;
}

CONSTRUCT_SINGLETON(ParticleFactory)
