/*
 * FragmentScheduler.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTSCHEDULER_HPP_
#define FRAGMENTSCHEDULER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>
#include <boost/asio.hpp>

#include "Connection.hpp"
#include "FragmentJob.hpp"
#include "FragmentQueue.hpp"
#include "FragmentResult.hpp"

/** FragmentScheduler serves FragmentJobs to Workers.
 *
 */
class FragmentScheduler
{
public:
  /// Constructor opens the acceptor and starts waiting for the first incoming
  /// Connection.
  FragmentScheduler(boost::asio::io_service& io_service, unsigned short port);

  /// Handle completion of a accept operation.
  void handle_accept(const boost::system::error_code& e, connection_ptr conn);

  /// Callback function when job has been sent.
  void handle_SendJob(const boost::system::error_code& e, connection_ptr conn);

  /// Callback function when result has been received.
  void handle_ReceiveResult(const boost::system::error_code& e, connection_ptr conn);

private:
  /// The acceptor object used to accept incoming socket connections.
  boost::asio::ip::tcp::acceptor acceptor_;

  /// result that is received from the client.
  FragmentResult result;

  /// Queue with data to be sent to each client.
  FragmentQueue JobsQueue;

  // static entity to indicate to clients that the queue is empty.
  static FragmentJob NoJob;
};

#endif /* FRAGMENTSCHEDULER_HPP_ */
