/*
 * \file FragmentWorker.hpp
 *
 *  Created on: Nov 18, 2011
 *      Author: heber
 */

#ifndef FRAGMENTWORKER_HPP_
#define FRAGMENTWORKER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <vector>
#include "Connection.hpp"
#include "FragmentJob.hpp"

/** Receives a job from Server to execute and return FragmentResult.
 *
 */
class FragmentWorker
{
public:
  /// Constructor starts the asynchronous connect operation.
  FragmentWorker(boost::asio::io_service& io_service,
      const std::string& host, const std::string& service);

  /// Handle completion of a connect operation.
  void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when job has been received.
  void handle_ReceiveJob(const boost::system::error_code& e);

  /// Callback function when result has been sent.
  void handle_SendResult(const boost::system::error_code& e);

  enum Exitflag_t {
    OkFlag = 0,
    NoJobFlag = 1,
    ErrorFlag = 255
  };

  /** Returns the flag of the handled operation.
   *
   */
  size_t getExitflag() const
  {
    return Exitflag;
  }

private:
  // static entity of an empty result
  static FragmentResult EmptyResult;

  /// The Connection to the server.
  Connection connection_;

  /// The data received from the server.
  FragmentJob job;

  /// The result created to be sent to the server.
  FragmentResult result;

  /// exit flag to give at program exit
  enum Exitflag_t Exitflag;
};

#endif /* FRAGMENTWORKER_HPP_ */
