/*
 * RandomNumberDistribution_Encapsulation.hpp
 *
 *  Created on: Jan 01, 2011
 *      Author: heber
 */

#ifndef RANDOMNUMBERDISTRIBUTION_ENCAPSULATION_HPP_
#define RANDOMNUMBERDISTRIBUTION_ENCAPSULATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <typeinfo>

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/bernoulli_distribution.hpp>
#include <boost/random/binomial_distribution.hpp>
#include <boost/random/cauchy_distribution.hpp>
#include <boost/random/exponential_distribution.hpp>
#include <boost/random/gamma_distribution.hpp>
#include <boost/random/geometric_distribution.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/lognormal_distribution.hpp>
#include <boost/random/normal_distribution.hpp>
#include <boost/random/poisson_distribution.hpp>
#include <boost/random/triangle_distribution.hpp>
#include <boost/random/uniform_01.hpp>
#include <boost/random/uniform_int.hpp>
#include <boost/random/uniform_on_sphere.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/random/uniform_smallint.hpp>

#include "CodePatterns/Creator.hpp"
#include "RandomNumberDistribution.hpp"

/** Template class that encapsulates the random number distributions from
 *  random::boost.
 *
 *
 * We need one template parameters:
 * -# the distribution - generates uniform random numbers
 */
template <class distribution>
class RandomNumberDistribution_Encapsulation :
  public RandomNumberDistribution,
  public Creator<
    RandomNumberDistribution,
    RandomNumberDistribution_Encapsulation<distribution>
  >
{
public:

  /** Getter for the type name of the internal distribution.
   *
   */
  std::string name() {
    return typeid(distribution_type).name();
  }

  /** Getter for the distribution instance.
   *
   * @return reference to instance
   */
  distribution& getDistribution() {
    return distribution_type;
  }

  /** Constructor that instantiates a specific random number generator and
   * distribution.
   * @param _distribution_type instance of the desired distribution
   */
  RandomNumberDistribution_Encapsulation()
  {}

  /** Destructor of the class.
   *
   */
  virtual ~RandomNumberDistribution_Encapsulation() {}
private:
  distribution distribution_type;
};

#endif /* RANDOMNUMBERDISTRIBUTION_ENCAPSULATION_HPP_ */
