/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * GLWorldScene.cpp
 *
 *  This is based on the Qt3D example "teaservice", specifically parts of teaservice.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLWorldScene.hpp"

#include "GLMoleculeScene.hpp"
#include "GLMoleculeObject.hpp"

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "molecule.hpp"
#include "World.hpp"


GLWorldScene::GLWorldScene(QObject *parent)
   : QObject(parent)
{
  init();

  //changeMaterials(false);
}

GLWorldScene::~GLWorldScene()
{}

/** Initialise the WorldScene with molecules and atoms from World.
 *
 */
void GLWorldScene::init()
{
  const std::vector<molecule*> &molecules = World::getInstance().getAllMolecules();

  if (molecules.size() > 0) {
    for (std::vector<molecule*>::const_iterator Runner = molecules.begin();
        Runner != molecules.end();
        Runner++) {
      // create molecule
      GLMoleculeScene * const molObject = new GLMoleculeScene(this, *Runner);
      MoleculeSceneList.push_back(molObject);
      connect (molObject, SIGNAL(clicked(atomId_t, moleculeId_t)), this, SLOT(molClicked(atomId_t, moleculeId_t)));
    }
  }
}

void GLWorldScene::initialize(QGLView *view, QGLPainter *painter) const
{
  for (List_MoleculeScene::const_iterator iter = MoleculeSceneList.begin();
      iter != MoleculeSceneList.end();
      ++iter) {
    (*iter)->initialize(view, painter);
  }
}


void GLWorldScene::draw(QGLPainter *painter) const
{
  for (List_MoleculeScene::const_iterator iter = MoleculeSceneList.begin();
      iter != MoleculeSceneList.end();
      ++iter) {
    (*iter)->draw(painter);
  }
}

void GLWorldScene::molClicked(atomId_t atom_no, moleculeId_t mol_no)
{
   qDebug("WorldScene: atom %d of molecule %d has been clicked", atom_no, mol_no);
}
