/*
 * logger.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#ifndef LOGGER_HPP_
#define LOGGER_HPP_

#include <iostream>

using namespace std;

class Verbose;

class logger {
public :
  static ostream *nix;
  static int verbosity;

  static logger* getInstance();
  static void purgeInstance();
  static bool DoOutput();
  static void setVerbosity(int verbosityLevel);

protected:
  /** Do not call this constructor directly, use getInstance() instead. */
  logger();
  /** Do not call this destructor directly, use purgeInstance() instead. */
  ~logger();

private:
  static logger* instance;
};

ostream& operator<<(class logger&l, const Verbose& ost);
ostream& operator<<(class logger*l, const Verbose& ost);

#endif /* LOGGER_HPP_ */
