/*
 * log.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#include "logger.hpp"
#include "errorLogger.hpp"

/**
 * Sets verbosity for the error logger and the standard logger.
 *
 * \param int verbosity level
 */
void setVerbosity(int verbosityLevel) {
  logger::getInstance()->setVerbosity(verbosityLevel);
  errorLogger::getInstance()->setVerbosity(verbosityLevel);
}

/**
 * Prints a log entry.
 *
 * \param indentation level of the message to log
 */
class logger * log() {
  return logger::getInstance();
}

/**
 * Prints an error log entry.
 *
 * \param indentation level of the message to log
 */
class errorLogger * elog() {
  return errorLogger::getInstance();
}
